import { Request, Response } from 'express';
import { AuthenticatedRequest } from '@/types';
/**
 * Vendor Controller - Handles vendor-related operations
 */
export declare class VendorController {
    /**
     * Get current vendor profile
     * GET /api/vendors/me
     */
    getMyProfile(req: AuthenticatedRequest, res: Response): Promise<Response<any, Record<string, any>> | undefined>;
    /**
     * Complete vendor onboarding
     * POST /api/vendors/onboarding
     */
    completeOnboarding(req: AuthenticatedRequest, res: Response): Promise<Response<any, Record<string, any>> | undefined>;
    /**
     * Update vendor profile
     * PUT /api/vendors/profile
     */
    updateProfile(req: AuthenticatedRequest, res: Response): Promise<Response<any, Record<string, any>> | undefined>;
    /**
     * Get vendor by ID (admin only)
     * GET /api/vendors/:id
     */
    getVendorById(req: Request, res: Response): Promise<Response<any, Record<string, any>> | undefined>;
    /**
     * Get all vendors (admin only)
     * GET /api/vendors
     */
    getAllVendors(req: Request, res: Response): Promise<Response<any, Record<string, any>> | undefined>;
}
export declare const vendorController: VendorController;
//# sourceMappingURL=controller.d.ts.map